/*
 * Decompiled with CFR 0.152.
 */
package com.ficapacity.presentation;

import com.ficapacity.engine.ExecutionThread;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class StatusFrame
extends JFrame {
    private ExecutionThread parentThread;
    private static StatusFrame obj;
    private static boolean bottomLocked;
    private JButton cancelJButton;
    private JButton closeJButton;
    private JButton goBottomJButton;
    private JScrollPane jScrollPane1;
    private JTextArea statusJTextArea;

    private StatusFrame(ExecutionThread parentThread) {
        this.initComponents();
        this.parentThread = parentThread;
    }

    public static void showFrame(ExecutionThread parentThread) {
        if (obj == null) {
            obj = new StatusFrame(parentThread);
        }
        StatusFrame.obj.closeJButton.setVisible(false);
        StatusFrame.obj.cancelJButton.setVisible(true);
        StatusFrame.obj.goBottomJButton.setVisible(true);
        bottomLocked = true;
        StatusFrame.obj.parentThread = parentThread;
        try {
            StatusFrame.obj.statusJTextArea.setText("");
            StatusFrame.obj.statusJTextArea.update(StatusFrame.obj.statusJTextArea.getGraphics());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        obj.setLocationRelativeTo(null);
        obj.setVisible(true);
    }

    public static void allowCloseFrame() {
        if (obj != null) {
            obj.close();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.statusJTextArea = new JTextArea();
        this.cancelJButton = new JButton();
        this.goBottomJButton = new JButton();
        this.closeJButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Running...");
        this.setCursor(new Cursor(3));
        this.setIconImages(null);
        this.setResizable(false);
        this.setType(Window.Type.UTILITY);
        this.statusJTextArea.setColumns(20);
        this.statusJTextArea.setLineWrap(true);
        this.statusJTextArea.setRows(20);
        this.statusJTextArea.setWrapStyleWord(true);
        this.statusJTextArea.setFocusable(false);
        this.jScrollPane1.setViewportView(this.statusJTextArea);
        this.cancelJButton.setText("Cancel");
        this.cancelJButton.setCursor(new Cursor(0));
        this.cancelJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatusFrame.this.cancelJButtonActionPerformed(evt);
            }
        });
        this.goBottomJButton.setText("Unlock from bottom");
        this.goBottomJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatusFrame.this.goBottomJButtonActionPerformed(evt);
            }
        });
        this.closeJButton.setText("Close");
        this.closeJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatusFrame.this.closeJButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 900, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.cancelJButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.goBottomJButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.closeJButton).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 455, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelJButton).addComponent(this.goBottomJButton).addComponent(this.closeJButton)).addContainerGap()));
        this.pack();
    }

    private void cancelJButtonActionPerformed(ActionEvent evt) {
        int reply = JOptionPane.showConfirmDialog(null, "Are you sure you want to cancel the process?", "Execution cancel", 0);
        if (reply == 1) {
            return;
        }
        this.parentThread.cancel(true);
    }

    private void goBottomJButtonActionPerformed(ActionEvent evt) {
        if (bottomLocked) {
            this.goBottomJButton.setText("Lock to bottom");
        } else {
            this.goBottomJButton.setText("Unlock from bottom");
        }
        bottomLocked = !bottomLocked;
    }

    private void closeJButtonActionPerformed(ActionEvent evt) {
        obj.setVisible(false);
    }

    public static void println(String text) {
        StatusFrame.obj.statusJTextArea.append(text + "\n");
        if (bottomLocked) {
            StatusFrame.obj.statusJTextArea.setCaretPosition(StatusFrame.obj.statusJTextArea.getDocument().getLength() - 1);
        }
    }

    private static void close() {
        StatusFrame.obj.closeJButton.setVisible(true);
        StatusFrame.obj.cancelJButton.setVisible(false);
        StatusFrame.obj.goBottomJButton.setVisible(false);
    }
}

