/*
 * Decompiled with CFR 0.152.
 */
package com.ficapacity.presentation;

import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class HoursTableModel
extends AbstractTableModel {
    private List<Integer> hours = new LinkedList<Integer>();

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (aValue == null || aValue.toString().isEmpty()) {
                this.hours.remove(rowIndex);
            } else {
                try {
                    if (rowIndex == this.hours.size()) {
                        this.hours.add((int)((Integer)aValue));
                    } else if (rowIndex < this.hours.size()) {
                        this.hours.set(rowIndex, (int)((Integer)aValue));
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            if (aValue == null || aValue.toString().isEmpty()) {
                return;
            }
            if (rowIndex == this.hours.size()) {
                return;
            }
            try {
                this.hours.add(rowIndex + 1, (int)((Integer)aValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Integer.class;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Start hour";
        }
        return "End hour";
    }

    @Override
    public int getRowCount() {
        return Math.max(1, this.hours.size());
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.hours.isEmpty()) {
            return "";
        }
        if (rowIndex < this.hours.size()) {
            if (columnIndex == 0) {
                if (rowIndex == this.hours.size() - 1) {
                    return "(" + this.hours.get(rowIndex) + ")";
                }
                return this.hours.get(rowIndex);
            }
            if (this.hours.size() > rowIndex + 1) {
                return this.hours.get(rowIndex + 1);
            }
        }
        return "";
    }

    public List<Integer> getHours() {
        return this.hours;
    }

    public boolean areHoursValid() {
        if (this.hours.size() <= 1) {
            return false;
        }
        Integer prevH = null;
        for (int h : this.hours) {
            if (prevH != null && prevH >= h) {
                return false;
            }
            prevH = h;
        }
        return true;
    }
}

