/*
 * Decompiled with CFR 0.152.
 */
package com.ficapacity.engine;

import com.ficapacity.engine.BufferType;
import com.ficapacity.engine.HeadwayBuffersManager;
import com.ficapacity.engine.LineBuffers;
import com.ficapacity.engine.Margins;
import com.ficapacity.engine.PositionException;
import com.ficapacity.engine.PositionMargin;
import com.ficapacity.engine.ThresholdBuffers;
import com.ficapacity.engine.Train;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TrainsGroup {
    private String groupName;
    private String line;
    private Set<Train> trains;
    private Set<String> trainNumbers;
    private Set<String> trainNumbersWithDates;
    private Margins margins;
    private HeadwayBuffersManager hbManager;
    private long totPositiveInDelays;
    private long totNegativeInDelays;
    private long totOutDelays;
    private double avgPositiveInDelays;
    private double avgNegativeInDelays;
    private double avgOutDelays;

    public TrainsGroup(String groupName, String lineName, double positiveInDelays, double negativeInDelays, double positiveOutDelays, List<ThresholdBuffers> thresholds) {
        this.groupName = groupName;
        this.line = lineName;
        this.trains = new HashSet<Train>();
        this.trainNumbers = new HashSet<String>();
        this.trainNumbersWithDates = new HashSet<String>();
        this.avgPositiveInDelays = positiveInDelays;
        this.totPositiveInDelays = (long)this.avgPositiveInDelays;
        this.avgNegativeInDelays = negativeInDelays;
        this.totNegativeInDelays = (long)this.avgNegativeInDelays;
        this.avgOutDelays = positiveOutDelays;
        this.totOutDelays = (long)this.avgOutDelays;
        this.margins = new Margins();
        this.hbManager = new HeadwayBuffersManager(thresholds);
    }

    public void addBuffer(String line, BufferType hType, int position, int plannedHdwy, int actualHdwy) throws PositionException {
        this.hbManager.addBufferFromActualHeadway(line, hType, position, plannedHdwy, actualHdwy);
    }

    public void addPositionMargin(PositionMargin pm) throws PositionException {
        this.margins.addPositionMargin(pm);
    }

    public List<PositionMargin> getPositionMargins() {
        return this.margins.getPositionMargins();
    }

    public String getName() {
        return this.groupName;
    }

    public String getLine() {
        return this.line;
    }

    public double getPositiveInputDelays() {
        if (this.trains.isEmpty()) {
            return this.avgPositiveInDelays;
        }
        return (double)this.totPositiveInDelays / (double)this.trains.size();
    }

    public double getNegativeInputDelays() {
        if (this.trains.isEmpty()) {
            return this.avgNegativeInDelays;
        }
        return (double)this.totNegativeInDelays / (double)this.trains.size();
    }

    public double getOutputDelays() {
        if (this.trains.isEmpty()) {
            return this.avgOutDelays;
        }
        return (double)this.totOutDelays / (double)this.trains.size();
    }

    public void addTrainToGroup(Train train) {
        this.trains.add(train);
        this.trainNumbers.add(train.getTrainNumber());
        this.trainNumbersWithDates.add(train.getTrainNumber() + "_" + train.getOperationDate().get(1) + "_" + train.getOperationDate().get(6));
    }

    public boolean isTrainNumberInGroup(String tn, String line) {
        if (tn == null || line == null) {
            return false;
        }
        if (!line.equals(this.line)) {
            return false;
        }
        return this.trainNumbers.contains(tn);
    }

    public Set<Train> getTrains() {
        return new HashSet<Train>(this.trains);
    }

    public void addPositionMargin(int p, int marg) {
        this.margins.addPositionMargin(p, marg);
    }

    public boolean isTrainNumberAndDateInGroup(String tn, String date) {
        return this.trainNumbersWithDates.contains(tn + "_" + date);
    }

    public void addInputDelay(Integer delay) {
        if (delay >= 0) {
            this.totPositiveInDelays += (long)delay.intValue();
        } else {
            this.totNegativeInDelays -= (long)delay.intValue();
        }
    }

    public void addOutputDelay(int delay) {
        if (delay > 0) {
            this.totOutDelays += (long)delay;
        }
    }

    public Double getPositionMargin(int p) {
        return this.margins.getTotalMargin(p) == null ? 0.0 : this.margins.getTotalMargin(p) / (double)(this.trains.isEmpty() ? 1 : this.trains.size());
    }

    public Map<String, LineBuffers> getLineBuffers() {
        return this.hbManager.getLineBuffers();
    }

    void resetBufferTimes() {
        this.hbManager.resetBufferTimes();
    }

    double getDelayEstimation(int nPositions, double alpha, double beta, double gamma, double delta, double epsilon) {
        try {
            double estDel = alpha;
            estDel += beta * this.hbManager.getBufferCriticality(this.line, nPositions, this.trains.size());
            estDel += gamma * this.margins.getTotalMargin(1);
            estDel += delta * this.getPositiveInputDelays();
            return estDel += epsilon * this.getNegativeInputDelays();
        }
        catch (Exception e) {
            System.err.println("Exception calculating getDelayEstimation for group " + this.getName());
            e.printStackTrace();
            return 0.0;
        }
    }

    public double getBufferCriticality(int nPositions) {
        return this.hbManager.getBufferCriticality(this.line, nPositions, this.trains.size());
    }

    private int getNBuffersFromThresholdStart(int tStart) {
        Map<String, LineBuffers> lineBuffersMap = this.hbManager.getLineBuffers();
        if (lineBuffersMap == null || lineBuffersMap.get(this.line) == null) {
            return 0;
        }
        Integer buffer = lineBuffersMap.get(this.line).getBuffer(BufferType.INITIAL_EDGE, 1, tStart);
        return buffer == null ? 0 : buffer;
    }
}

