/*
 * Decompiled with CFR 0.152.
 */
package com.ficapacity.engine;

import com.ficapacity.engine.BufferType;
import com.ficapacity.engine.PositionBuffers;
import com.ficapacity.engine.PositionException;
import com.ficapacity.engine.ThresholdBuffers;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Buffers {
    private BufferType headwayType;
    private Map<Integer, PositionBuffers> positionBuffers;

    public Buffers(BufferType headwayType) {
        this.headwayType = headwayType;
        this.positionBuffers = new TreeMap<Integer, PositionBuffers>();
    }

    public void addPositionBuffers(PositionBuffers ph) throws PositionException {
        if (this.positionBuffers.containsKey(ph.getPosition())) {
            for (ThresholdBuffers th : ph.getThresholdBuffers()) {
                this.positionBuffers.get(ph.getPosition()).addThresholdBuffers(th);
            }
        } else {
            this.positionBuffers.put(ph.getPosition(), ph);
        }
    }

    public BufferType getHeadwayType() {
        return this.headwayType;
    }

    public List<PositionBuffers> getPositionBuffers() {
        LinkedList<PositionBuffers> phList = new LinkedList<PositionBuffers>();
        for (PositionBuffers ph : this.positionBuffers.values()) {
            phList.add(ph);
        }
        return phList;
    }

    public Integer getBuffer(int t, int p) {
        if (!this.positionBuffers.containsKey(p)) {
            return null;
        }
        return this.positionBuffers.get(p).getThresholdBuffer(t);
    }
}

