/*
 * Decompiled with CFR 0.152.
 */
package com.ficapacity.engine;

import com.ficapacity.engine.PositionException;
import com.ficapacity.engine.PositionMargin;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Margins {
    private Map<Integer, PositionMargin> margins = new TreeMap<Integer, PositionMargin>();

    public void addPositionMargin(PositionMargin pm) throws PositionException {
        if (this.margins.containsKey(pm.getPosition())) {
            throw new PositionException(pm.getPosition());
        }
        this.margins.put(pm.getPosition(), pm);
    }

    public List<PositionMargin> getPositionMargins() {
        LinkedList<PositionMargin> pmList = new LinkedList<PositionMargin>();
        for (PositionMargin pm : this.margins.values()) {
            pmList.add(pm);
        }
        return pmList;
    }

    void addPositionMargin(int p, int marg) {
        if (!this.margins.containsKey(p)) {
            this.margins.put(p, new PositionMargin(p, marg));
        } else {
            this.margins.get(p).addMargin(marg);
        }
    }

    public Double getTotalMargin(int p) {
        if (!this.margins.containsKey(p)) {
            return null;
        }
        return this.margins.get(p).getTotalMargin();
    }
}

