/*
 * Decompiled with CFR 0.152.
 */
package com.ficapacity.engine;

import com.ficapacity.engine.BufferType;
import com.ficapacity.engine.DataLoaderException;
import com.ficapacity.engine.DayPassTimes;
import com.ficapacity.engine.LineBuffers;
import com.ficapacity.engine.OutDelaysCalculationType;
import com.ficapacity.engine.PositionException;
import com.ficapacity.engine.PositioningMethod;
import com.ficapacity.engine.ThresholdBuffers;
import com.ficapacity.engine.Train;
import com.ficapacity.engine.TrainGroupingMethod;
import com.ficapacity.engine.TrainsGroup;
import com.ficapacity.engine.TrainsGroupsData;
import com.ficapacity.engine.UseMode;
import com.ficapacity.presentation.MainFrame;
import com.ficapacity.presentation.StatusFrame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import javax.swing.SwingWorker;

public class ExecutionThread
extends SwingWorker {
    private MainFrame parent;
    private TrainsGroupsData data;
    private Map<String, List<File>> headwayFiles;
    private Map<String, List<File>> marginsFiles;
    private Map<String, List<File>> secMarginsFiles;
    private Map<String, File> corridorFiles;
    private Map<String, List<File>> delaysFiles;
    private TrainGroupingMethod grouping;
    private PositioningMethod positioning;
    private Integer nSteps;
    private List<Integer> hours;
    private List<Integer> thresholds;
    private double alpha;
    private double beta;
    private double gamma;
    private double delta;
    private double epsilon;
    private OutDelaysCalculationType delaysCalculationType;
    private UseMode useMode;
    private String workingFolder;
    private String outputFolder;
    private String parametersString;

    public ExecutionThread(MainFrame parent, TrainsGroupsData data, Map<String, List<File>> headwayFiles, Map<String, List<File>> marginsFiles, Map<String, List<File>> secMarginsFiles, Map<String, File> corridorFiles, Map<String, List<File>> delaysFiles, TrainGroupingMethod grouping, PositioningMethod positioning, Integer nSteps, List<Integer> hours, List<Integer> thresholds, double alpha, double beta, double gamma, double delta, double epsilon, OutDelaysCalculationType delaysCalculationType, UseMode useMode, String workingFolder, String outputFolder, String parametersString) {
        this.parent = parent;
        this.data = data;
        this.headwayFiles = headwayFiles;
        this.marginsFiles = marginsFiles;
        this.secMarginsFiles = secMarginsFiles;
        this.corridorFiles = corridorFiles;
        this.delaysFiles = delaysFiles;
        this.grouping = grouping;
        this.positioning = positioning;
        this.nSteps = nSteps;
        this.hours = hours;
        this.thresholds = thresholds;
        this.alpha = alpha;
        this.beta = beta;
        this.gamma = gamma;
        this.delta = delta;
        this.epsilon = epsilon;
        this.delaysCalculationType = delaysCalculationType;
        this.useMode = useMode;
        this.workingFolder = workingFolder;
        this.outputFolder = outputFolder;
        this.parametersString = parametersString;
    }

    protected Object doInBackground() throws Exception {
        StatusFrame.println("Loading corridors...");
        this.loadCorridors(this.data, this.corridorFiles);
        StatusFrame.println("Creating groups...");
        this.createGroups(this.data, this.delaysFiles, this.grouping, this.positioning, this.nSteps, this.hours, this.thresholds);
        StatusFrame.println("Loading delays...");
        this.loadDelays(this.data, this.delaysCalculationType, this.delaysFiles);
        StatusFrame.println("Loading headways...");
        this.loadHeadways(this.data, this.data.getCorridorSizes(), this.headwayFiles);
        this.calculateBufferTimes(this.data);
        StatusFrame.println("Loading margins...");
        this.loadMargins(this.data, this.marginsFiles, this.secMarginsFiles);
        StatusFrame.println("Writing data...");
        this.writeData(this.data, this.thresholds, this.outputFolder + "/regressionData_" + this.parametersString, this.useMode);
        StatusFrame.println("\n\nALL DONE!");
        StatusFrame.allowCloseFrame();
        return null;
    }

    @Override
    protected void done() {
        try {
            this.get();
            this.parent.successfulThread();
        }
        catch (Exception ex) {
            if (ex.getClass().equals(CancellationException.class)) {
                StatusFrame.println("\n\nCANCELED!");
            } else {
                StatusFrame.println("\n\nERROR LOADING DATA!");
                ex.printStackTrace();
            }
            this.parent.failedThread();
        }
        StatusFrame.allowCloseFrame();
    }

    public void loadCorridors(TrainsGroupsData data, Map<String, File> files) throws DataLoaderException, CancellationException {
        for (String line : files.keySet()) {
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            StatusFrame.println("Line " + line + " - Reading file: " + files.get(line).getAbsolutePath());
            try {
                BufferedReader br = new BufferedReader(new FileReader(files.get(line)));
                Throwable throwable = null;
                try {
                    String sCurrentLine = br.readLine();
                    while ((sCurrentLine = br.readLine()) != null) {
                        String[] scArr = sCurrentLine.split(";");
                        if (scArr.length != 7 && scArr.length != 4) continue;
                        try {
                            int p = Integer.parseInt(scArr[1]);
                            String orig = scArr[2];
                            String dest = scArr[3];
                            if (p == 1) {
                                data.addCorridorPass(line, p, orig);
                            } else if (!data.getCorridor(line).get(p).equals(orig)) {
                                throw new DataLoaderException("Incoherent corridor data for line " + line + " at pass " + p);
                            }
                            data.addCorridorPass(line, p + 1, dest);
                        }
                        catch (NumberFormatException e) {
                            throw new DataLoaderException("Error parsing corridor position");
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (br == null) continue;
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    br.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DataLoaderException("Exception loading corridor for line " + line + ": " + e.getMessage());
            }
        }
    }

    public void loadHeadways(TrainsGroupsData data, Map<String, Integer> nStations, Map<String, List<File>> fileList) throws DataLoaderException, PositionException, CancellationException {
        for (String line : fileList.keySet()) {
            for (File file : fileList.get(line)) {
                if (this.isCancelled()) {
                    throw new CancellationException();
                }
                StatusFrame.println("Line " + line + " - Reading file: " + file.getAbsolutePath());
                try {
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    Throwable throwable = null;
                    try {
                        String sCurrentLine;
                        Boolean perTrainImport = null;
                        while ((sCurrentLine = br.readLine()) != null) {
                            String[] scArr = sCurrentLine.split(";");
                            if (perTrainImport == null) {
                                if (scArr.length == 3) {
                                    perTrainImport = false;
                                } else {
                                    if (scArr.length != 4) continue;
                                    perTrainImport = true;
                                }
                            }
                            if (perTrainImport.booleanValue()) {
                                if (scArr.length != 4) continue;
                                try {
                                    int p = Integer.parseInt(scArr[0]);
                                    String hTypeStr = scArr[1];
                                    BufferType hType = null;
                                    switch (hTypeStr) {
                                        case "Start": {
                                            hType = BufferType.INITIAL_EDGE;
                                            break;
                                        }
                                        case "End": {
                                            hType = BufferType.FINAL_EDGE;
                                            break;
                                        }
                                        case "Station": {
                                            hType = BufferType.STATION;
                                        }
                                    }
                                    if (hType == null) continue;
                                    String tn = scArr[2];
                                    int hdwy = Math.min(360, Integer.parseInt(scArr[3]));
                                    data.addPositionHeadway(tn, hType, p, hdwy);
                                }
                                catch (Exception p) {}
                                continue;
                            }
                            if (scArr.length != 3) continue;
                            try {
                                String orig = scArr[0];
                                String dest = scArr[1];
                                List<Integer> positions = data.getStationsPositionsOnLine(line, orig, dest);
                                if (positions == null || positions.isEmpty()) continue;
                                int hdwy = Integer.parseInt(scArr[2]);
                                for (Integer pos : positions) {
                                    for (String tn : data.getTrainNumbersTravellingOnLinePass(line, pos)) {
                                        data.addPositionHeadway(tn, BufferType.INITIAL_EDGE, pos, 0);
                                        data.addPositionHeadway(tn, BufferType.FINAL_EDGE, pos, hdwy);
                                        data.addPositionHeadway(tn, BufferType.STATION, pos, 0);
                                    }
                                }
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (br == null) continue;
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        br.close();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public void loadMargins(TrainsGroupsData data, Map<String, List<File>> fileList, Map<String, List<File>> secondaryFileList) throws DataLoaderException, CancellationException {
        for (String line : fileList.keySet()) {
            Set<TrainsGroup> tgSet;
            int marg;
            String tn;
            int p;
            String[] scArr;
            String sCurrentLine2;
            Throwable throwable;
            BufferedReader br;
            HashSet<String> primaryProcessedTrainNumbers = new HashSet<String>();
            for (File file : fileList.get(line)) {
                if (this.isCancelled()) {
                    throw new CancellationException();
                }
                StatusFrame.println("Line " + line + " - Reading file: " + file.getAbsolutePath());
                try {
                    br = new BufferedReader(new FileReader(file));
                    throwable = null;
                    try {
                        sCurrentLine2 = br.readLine();
                        while ((sCurrentLine2 = br.readLine()) != null) {
                            scArr = sCurrentLine2.split(";");
                            if (scArr.length != 3) continue;
                            p = Integer.parseInt(scArr[0]);
                            tn = scArr[1];
                            marg = Integer.parseInt(scArr[2]);
                            primaryProcessedTrainNumbers.add(tn);
                            tgSet = data.getTrainsGroupsFromTrainNumberAndLine(line, tn);
                            for (TrainsGroup tg : tgSet) {
                                tg.addPositionMargin(data.getMappedPosition(line, p), marg);
                            }
                        }
                    }
                    catch (Throwable sCurrentLine2) {
                        throwable = sCurrentLine2;
                        throw sCurrentLine2;
                    }
                    finally {
                        if (br == null) continue;
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable sCurrentLine2) {
                                throwable.addSuppressed(sCurrentLine2);
                            }
                            continue;
                        }
                        br.close();
                    }
                }
                catch (Exception e) {
                    throw new DataLoaderException("Exception loading margins: " + e.getMessage());
                }
            }
            if (secondaryFileList == null || secondaryFileList.isEmpty()) continue;
            for (File file : secondaryFileList.get(line)) {
                if (this.isCancelled()) {
                    throw new CancellationException();
                }
                if (!file.exists()) continue;
                StatusFrame.println("Line " + line + " - Reading file: " + file.getAbsolutePath());
                try {
                    br = new BufferedReader(new FileReader(file));
                    throwable = null;
                    try {
                        sCurrentLine2 = br.readLine();
                        while ((sCurrentLine2 = br.readLine()) != null) {
                            scArr = sCurrentLine2.split(";");
                            if (scArr.length != 3) continue;
                            p = Integer.parseInt(scArr[0]);
                            tn = scArr[1];
                            if (primaryProcessedTrainNumbers.contains(tn)) continue;
                            marg = Integer.parseInt(scArr[2]);
                            tgSet = data.getTrainsGroupsFromTrainNumberAndLine(line, tn);
                            for (TrainsGroup tg : tgSet) {
                                tg.addPositionMargin(data.getMappedPosition(line, p), marg);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (br == null) continue;
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        br.close();
                    }
                }
                catch (Exception e) {
                    throw new DataLoaderException("Exception loading margins: " + e.getMessage());
                }
            }
        }
    }

    public void loadDelays(TrainsGroupsData data, OutDelaysCalculationType calcType, Map<String, List<File>> files) throws DataLoaderException, PositionException, CancellationException {
        data.resetLoadedTimes();
        for (String line : files.keySet()) {
            block16: for (File file : files.get(line)) {
                if (this.isCancelled()) {
                    throw new CancellationException();
                }
                StatusFrame.println("Line " + line + " - Reading file: " + file.getAbsolutePath());
                try {
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    Throwable throwable = null;
                    try {
                        String sCurrentLine = br.readLine();
                        String[] scArr = sCurrentLine.split(";");
                        int decFormat10 = scArr.length == 10 ? 1 : 0;
                        String lastTn = null;
                        Calendar lastDate = null;
                        String lastStat = null;
                        Integer outDelay = null;
                        Integer lastDep = null;
                        Integer lastAbsDep = null;
                        TrainsGroup tg = null;
                        boolean addedIn = false;
                        boolean prevCorr = false;
                        while (true) {
                            boolean inCorr;
                            sCurrentLine = br.readLine();
                            String tn = null;
                            Calendar date = null;
                            String stat = null;
                            Integer arrDiff = null;
                            Integer depDiff = null;
                            Integer absArr = null;
                            Integer absDep = null;
                            if (sCurrentLine != null) {
                                scArr = sCurrentLine.split(";");
                                if (scArr.length != 11 - decFormat10) continue;
                                tn = scArr[1 - decFormat10];
                                date = this.getCalendarFromString(scArr[2 - decFormat10]);
                                stat = scArr[4 - decFormat10];
                                absArr = scArr[9 - decFormat10].isEmpty() ? null : Integer.valueOf(Integer.parseInt(scArr[9 - decFormat10]));
                                absDep = scArr[10 - decFormat10].isEmpty() ? null : Integer.valueOf(Integer.parseInt(scArr[10 - decFormat10]));
                                try {
                                    arrDiff = Integer.parseInt(scArr[5 - decFormat10]);
                                }
                                catch (NumberFormatException nfe) {
                                    arrDiff = null;
                                }
                                try {
                                    depDiff = Integer.parseInt(scArr[6 - decFormat10]);
                                }
                                catch (NumberFormatException nfe) {
                                    depDiff = null;
                                }
                            }
                            if ((inCorr = this.isInCorridor(data, line, lastStat, stat)) && absArr != null) {
                                for (Integer pos : data.getStationsPositionsOnLine(line, lastStat, stat)) {
                                    data.addArrivalTime(date, line, pos + 1, tn, absArr);
                                }
                            }
                            if (lastTn == null || tn == null || !lastTn.equals(tn) || !this.areSameDates(lastDate, date)) {
                                if (outDelay != null && tg != null) {
                                    tg.addOutputDelay(outDelay);
                                }
                                if (tn == null) continue block16;
                                tg = data.getTrainsGroupFromTrainNumberLineAndDay(line, tn, DayPassTimes.getStringFromCalendar(date));
                                addedIn = false;
                                inCorr = false;
                                outDelay = null;
                            } else if (inCorr && lastAbsDep != null) {
                                for (Integer pos : data.getStationsPositionsOnLine(line, lastStat, stat)) {
                                    data.addDepartureTime(date, line, pos, tn, lastAbsDep);
                                }
                            }
                            if (!addedIn && inCorr && lastDep != null && tg != null) {
                                tg.addInputDelay(lastDep);
                                addedIn = true;
                            }
                            if (inCorr && arrDiff != null) {
                                outDelay = outDelay == null || calcType == OutDelaysCalculationType.LAST_STATION ? arrDiff : Integer.valueOf(outDelay + arrDiff);
                            }
                            lastTn = tn;
                            lastDate = date;
                            lastStat = stat;
                            lastDep = depDiff;
                            lastAbsDep = absDep;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (br == null) continue;
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        br.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new DataLoaderException("Exception loading delays: " + e.getMessage());
                }
            }
        }
    }

    private boolean isInCorridor(TrainsGroupsData data, String line, String prevStat, String nextStat) {
        if (prevStat == null || nextStat == null || data == null) {
            return false;
        }
        TreeMap<Integer, String> stations = new TreeMap<Integer, String>(data.getCorridor(line));
        String lastStat = null;
        for (String stat : stations.values()) {
            if (lastStat != null && stat != null && lastStat.equals(prevStat) && nextStat.equals(stat)) {
                return true;
            }
            lastStat = stat;
        }
        return false;
    }

    private boolean areSameDates(Calendar d1, Calendar d2) {
        return d1 != null && d2 != null && d1.get(1) == d2.get(1) && d1.get(6) == d2.get(6);
    }

    private Calendar getCalendarFromString(String dateStr) {
        int day;
        int month;
        int year;
        String[] splitStr;
        String[] stringArray = splitStr = dateStr.contains("/") ? dateStr.split("/") : dateStr.split("-");
        if (splitStr.length != 3) {
            try {
                int nDays = Integer.parseInt(dateStr);
                GregorianCalendar c = new GregorianCalendar();
                c.set(5, 1);
                c.set(2, 0);
                c.set(1, 1900);
                ((Calendar)c).add(6, nDays);
                return c;
            }
            catch (Exception e) {
                return null;
            }
        }
        int yInd = splitStr[0].length() == 4 ? 0 : 2;
        int mInd = 1;
        int dInd = splitStr[0].length() == 4 ? 2 : 0;
        try {
            year = Integer.parseInt(splitStr[yInd]);
            month = Integer.parseInt(splitStr[mInd]);
            day = Integer.parseInt(splitStr[dInd]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c;
    }

    private Integer getTimeBandForHour(List<Integer> hours, int hour) {
        Integer prevH = null;
        for (int h : hours) {
            if (prevH != null && hour >= prevH && hour < h) {
                return prevH;
            }
            prevH = h;
        }
        return null;
    }

    public void createGroups(TrainsGroupsData data, Map<String, List<File>> fileList, TrainGroupingMethod grouping, PositioningMethod method, Integer positioningSteps, List<Integer> hours, List<Integer> thresholds) throws DataLoaderException, CancellationException {
        List<ThresholdBuffers> tbList = this.getThresholdBuffersList(thresholds);
        for (String line : fileList.keySet()) {
            for (File file : fileList.get(line)) {
                if (this.isCancelled()) {
                    throw new CancellationException();
                }
                StatusFrame.println("Line " + line + " - Reading file: " + file.getAbsolutePath());
                try {
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    Throwable throwable = null;
                    try {
                        String sCurrentLine = br.readLine();
                        String[] scArr = sCurrentLine.split(";");
                        int decFormat10 = scArr.length == 10 ? 1 : 0;
                        String prevTn = "";
                        Calendar prevDate = null;
                        String prevStat = "";
                        while ((sCurrentLine = br.readLine()) != null) {
                            scArr = sCurrentLine.split(";");
                            if (scArr.length != 11 - decFormat10) continue;
                            boolean tAdded = false;
                            try {
                                int p = Integer.parseInt(scArr[3 - decFormat10]);
                                String tn = scArr[1 - decFormat10];
                                String stat = scArr[4 - decFormat10];
                                String date = scArr[2 - decFormat10];
                                Calendar cal = this.getCalendarFromString(date);
                                if (!tn.equals(prevTn) || !this.areSameDates(cal, prevDate)) {
                                    tAdded = false;
                                }
                                if (!tAdded && this.isInCorridor(data, line, prevStat, stat)) {
                                    Integer hBand;
                                    int h;
                                    Integer time;
                                    if (grouping == TrainGroupingMethod.DAY) {
                                        data.addTrainToGroup(new Train(tn, cal), "TG_" + line + "_" + date, line, tbList);
                                        tAdded = true;
                                    } else if (grouping == TrainGroupingMethod.DAY_HOUR) {
                                        time = null;
                                        if (scArr[7 - decFormat10].isEmpty()) {
                                            if (!scArr[8 - decFormat10].isEmpty()) {
                                                time = Integer.parseInt(scArr[8 - decFormat10]);
                                            }
                                        } else {
                                            time = Integer.parseInt(scArr[7 - decFormat10]);
                                        }
                                        if (time != null) {
                                            h = time / 3600;
                                            hBand = this.getTimeBandForHour(hours, h);
                                            if (hBand != null) {
                                                data.addTrainToGroup(new Train(tn, cal), "TG_" + line + "_" + date + "_" + hBand, line, tbList);
                                            }
                                            tAdded = true;
                                        }
                                    } else if (grouping == TrainGroupingMethod.HOUR) {
                                        time = null;
                                        if (scArr[7 - decFormat10].isEmpty()) {
                                            if (!scArr[8 - decFormat10].isEmpty()) {
                                                time = Integer.parseInt(scArr[8 - decFormat10]);
                                            }
                                        } else {
                                            time = Integer.parseInt(scArr[7 - decFormat10]);
                                        }
                                        if (time != null) {
                                            h = time / 3600;
                                            hBand = this.getTimeBandForHour(hours, h);
                                            if (hBand != null) {
                                                data.addTrainToGroup(new Train(tn, cal), "TG_" + line + "_" + hBand, line, tbList);
                                            }
                                            tAdded = true;
                                        }
                                    }
                                }
                                prevDate = cal;
                                prevStat = stat;
                                prevTn = tn;
                            }
                            catch (NumberFormatException e) {
                                throw new DataLoaderException("Wrong format in delays data");
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (br == null) continue;
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        br.close();
                    }
                }
                catch (Exception e) {
                    throw new DataLoaderException("Exception creating groups: " + e.getMessage());
                }
            }
            data.definePositionMapping(line, method, positioningSteps);
        }
    }

    public void writeData(TrainsGroupsData data, List<Integer> thresholds, String fileRadix, UseMode useMode) {
        File file = new File(fileRadix + ".csv");
        int i = 2;
        while (file.exists()) {
            file = new File(fileRadix + "_" + i + ".csv");
            ++i;
        }
        try (BufferedWriter br = new BufferedWriter(new FileWriter(file));){
            br.write("Group;Line;Trains;");
            for (int t : thresholds) {
                if (data.getMappedPositions() > 1) {
                    for (int p = 1; p <= data.getMappedPositions(); ++p) {
                        br.write("buff_" + t + "_" + p + ";");
                    }
                    continue;
                }
                br.write("buff_" + t + ";");
            }
            br.write("buffWeight;");
            if (data.getMappedPositions() > 1) {
                for (int p = 1; p <= data.getMappedPositions(); ++p) {
                    br.write("marg_" + p + ";");
                }
            } else {
                br.write("marg;");
            }
            br.write("Din+;Din-;Dout+" + (this.useMode == UseMode.CASE_STUDY ? ";ED+" : "") + "\n");
            for (TrainsGroup tg : data.getTrainsGroups()) {
                br.write(tg.getName() + ";" + tg.getLine() + ";" + tg.getTrains().size() + ";");
                if (!tg.getLineBuffers().containsKey(tg.getLine())) {
                    for (int t : thresholds) {
                        br.write("0;");
                    }
                    br.write("0;");
                } else {
                    LineBuffers lb = tg.getLineBuffers().get(tg.getLine());
                    BufferType hType = BufferType.FINAL_EDGE;
                    for (int t : thresholds) {
                        for (int p = 1; p <= data.getMappedPositions(); ++p) {
                            Integer buff = lb.getBuffer(hType, p, t);
                            br.write((buff != null ? buff : "") + ";");
                        }
                    }
                    br.write("" + tg.getBufferCriticality(data.getMappedPositions()) + ";");
                }
                double marg = 0.0;
                for (int p = 1; p <= data.getMappedPositions(); ++p) {
                    Double pmarg = tg.getPositionMargin(p);
                    marg += pmarg == null ? 0.0 : pmarg;
                }
                br.write(marg + ";");
                br.write(tg.getPositiveInputDelays() + ";" + tg.getNegativeInputDelays() + ";" + tg.getOutputDelays());
                if (useMode == UseMode.CASE_STUDY) {
                    br.write(";" + tg.getDelayEstimation(data.getMappedPositions(), this.alpha, this.beta, this.gamma, this.delta, this.epsilon));
                }
                br.write("\n");
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<ThresholdBuffers> getThresholdBuffersList(List<Integer> thresholds) {
        LinkedList<ThresholdBuffers> tbList = new LinkedList<ThresholdBuffers>();
        Integer lastT = null;
        for (Integer tVal : thresholds) {
            if (lastT != null) {
                tbList.add(new ThresholdBuffers(lastT, tVal, 0));
            }
            lastT = tVal;
        }
        if (lastT != null) {
            tbList.add(new ThresholdBuffers(lastT, 0));
        }
        return tbList;
    }

    private void calculateBufferTimes(TrainsGroupsData data) {
        data.resetBufferTimes();
        for (String line : data.getLines()) {
            StatusFrame.println("Calculating buffer times for line " + line + "...");
            try {
                data.calculateBufferTimes(line);
            }
            catch (PositionException pe) {
                pe.printStackTrace();
            }
            StatusFrame.println("Resetting loaded times for line " + line + "...");
            data.resetLineTimes(line);
        }
    }
}

