/*
 * Decompiled with CFR 0.152.
 */
package com.ficapacity.presentation;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ThresholdsTableModel
extends AbstractTableModel {
    private List<Integer> thresholds = new ArrayList<Integer>();

    public ThresholdsTableModel() {
        this.thresholds.add(0);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (aValue == null || aValue.toString().isEmpty()) {
                    this.thresholds.remove(rowIndex);
                }
                try {
                    if (rowIndex == this.thresholds.size()) {
                        try {
                            this.thresholds.add(Integer.parseInt(aValue.toString()));
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            return;
                        }
                    }
                    if (rowIndex >= this.thresholds.size()) break;
                    this.thresholds.set(rowIndex, Integer.parseInt(aValue.toString()));
                    break;
                }
                catch (Exception e) {
                    return;
                }
            }
            case 1: {
                if (aValue == null || aValue.toString().isEmpty()) {
                    return;
                }
                if (rowIndex == this.thresholds.size()) {
                    return;
                }
                try {
                    if (rowIndex == this.thresholds.size() - 1) {
                        this.thresholds.add(rowIndex + 1, Integer.parseInt(aValue.toString()));
                        break;
                    }
                    this.thresholds.set(rowIndex + 1, Integer.parseInt(aValue.toString()));
                    break;
                }
                catch (Exception e) {
                    return;
                }
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Min buffer (s)";
            }
            case 1: {
                return "Max buffer (s)";
            }
            case 2: {
                return "Beta";
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.thresholds.size() + 1;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (rowIndex >= this.thresholds.size()) break;
                return this.thresholds.get(rowIndex);
            }
            case 1: {
                if (rowIndex >= this.thresholds.size() - 1) break;
                return this.thresholds.get(rowIndex + 1);
            }
        }
        return "";
    }

    List<Integer> getThresholds() {
        return this.thresholds;
    }
}

