/*
 * Decompiled with CFR 0.152.
 */
package com.ficapacity.presentation;

import com.ficapacity.engine.BufferType;
import com.ficapacity.engine.Buffers;
import com.ficapacity.engine.ExecutionThread;
import com.ficapacity.engine.OutDelaysCalculationType;
import com.ficapacity.engine.PositionBuffers;
import com.ficapacity.engine.PositionMargin;
import com.ficapacity.engine.PositioningMethod;
import com.ficapacity.engine.ThresholdBuffers;
import com.ficapacity.engine.Train;
import com.ficapacity.engine.TrainGroupingMethod;
import com.ficapacity.engine.TrainsGroup;
import com.ficapacity.engine.TrainsGroupsData;
import com.ficapacity.engine.UseMode;
import com.ficapacity.presentation.HoursTableModel;
import com.ficapacity.presentation.StatusFrame;
import com.ficapacity.presentation.ThresholdsTableModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public class MainFrame
extends JFrame {
    private Random rand = null;
    private ThresholdsTableModel thresholdsTM = new ThresholdsTableModel();
    private HoursTableModel hoursTM = new HoursTableModel();
    private File workingFolder;
    private File outputFolder;
    private Map<String, List<File>> headwayFiles;
    private Map<String, List<File>> marginsFiles;
    private Map<String, List<File>> secMarginsFiles;
    private Map<String, File> corridorFiles;
    private Map<String, List<File>> delaysFiles;
    private boolean validInput = false;
    private TrainsGroupsData data = null;
    private double missingMarginPct = 10.0;
    private static final String textAreaText = "Working folder: {0}\n\n{1}";
    private static final String SELECT_FOLDER_INFO_TEXT = "Single files option: loads data from a single folder only\n\nMultiple folders option: use to load data from different scenarios.\nSelect a folder with one subfolder per scenario, with each scenario folder having one subfolder per line,\ninside of which .csv files are found. Example location of a corridor file: working_folder/scenario_folder/line_A/corridor.csv";
    private double alpha = 0.0;
    private double beta = 0.0;
    private double gamma = 0.0;
    private double delta = 0.0;
    private double epsilon = 0.0;
    private ButtonGroup buttonGroupImportFiles;
    private ButtonGroup buttonGroupOutputDelay;
    private ButtonGroup buttonGroupPositioning;
    private ButtonGroup buttonGroupTrainsGrouping;
    private JButton jButtonBufferThresholdsInfo;
    private JButton jButtonCalculateOutputDelayAtInfo;
    private JButton jButtonGroupTrainsInfo;
    private JButton jButtonHoursInfo;
    private JButton jButtonLoad;
    private JButton jButtonModeInfo;
    private JButton jButtonRegressionParametersInfo;
    private JButton jButtonSelectFolderInfo;
    private JButton jButtonSelectOutputFolder;
    private JButton jButtonSelectWorkingFolder;
    private JLabel jLabelAlpha;
    private JLabel jLabelBeta;
    private JLabel jLabelDataInputStatus;
    private JLabel jLabelDelta;
    private JLabel jLabelEpsilon;
    private JLabel jLabelGamma;
    private JLabel jLabelOutputDelayCalculation;
    private JLabel jLabelOutputFolder;
    private JLabel jLabelTrainsGrouping;
    private JPanel jPanelBuffers;
    private JPanel jPanelFilesInFolder;
    private JPanel jPanelGroupTrains;
    private JPanel jPanelHours;
    private JPanel jPanelMain;
    private JPanel jPanelOutputDelay;
    private JPanel jPanelRegressionParameters;
    private JRadioButton jRadioButtonGroupByDay;
    private JRadioButton jRadioButtonGroupByDayAndHour;
    private JRadioButton jRadioButtonGroupByHour;
    private JRadioButton jRadioButtonMultipleFolders;
    private JRadioButton jRadioButtonOutDelayAtAllStations;
    private JRadioButton jRadioButtonOutDelayAtLastStation;
    private JRadioButton jRadioButtonSingleFiles;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPanePanes;
    private JTable jTable1;
    private JTable jTableHeadwayThresholds;
    private JTextArea jTextAreaDataStatus;
    private JTextField jTextFieldAlpha;
    private JTextField jTextFieldBeta;
    private JTextField jTextFieldDelta;
    private JTextField jTextFieldEpsilon;
    private JTextField jTextFieldGamma;
    private JToggleButton jToggleButtonCaseStudyMode;
    private JToggleButton jToggleButtonDataAnalysis;

    public MainFrame() {
        this.initComponents();
        this.workingFolder = null;
        this.headwayFiles = new HashMap<String, List<File>>();
        this.marginsFiles = new HashMap<String, List<File>>();
        this.secMarginsFiles = new HashMap<String, List<File>>();
        this.corridorFiles = new HashMap<String, File>();
        this.delaysFiles = new HashMap<String, List<File>>();
        this.updateHoursTabEnabled();
        this.setTitle("Data analyzer for regression");
    }

    private void initComponents() {
        this.buttonGroupTrainsGrouping = new ButtonGroup();
        this.buttonGroupOutputDelay = new ButtonGroup();
        this.buttonGroupImportFiles = new ButtonGroup();
        this.buttonGroupPositioning = new ButtonGroup();
        this.jPanelMain = new JPanel();
        this.jButtonSelectWorkingFolder = new JButton();
        this.jButtonLoad = new JButton();
        this.jTabbedPanePanes = new JTabbedPane();
        this.jPanelBuffers = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableHeadwayThresholds = new JTable();
        this.jButtonBufferThresholdsInfo = new JButton();
        this.jPanelHours = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButtonHoursInfo = new JButton();
        this.jRadioButtonSingleFiles = new JRadioButton();
        this.jRadioButtonMultipleFolders = new JRadioButton();
        this.jPanelFilesInFolder = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextAreaDataStatus = new JTextArea();
        this.jLabelDataInputStatus = new JLabel();
        this.jPanelGroupTrains = new JPanel();
        this.jLabelTrainsGrouping = new JLabel();
        this.jRadioButtonGroupByDay = new JRadioButton();
        this.jRadioButtonGroupByHour = new JRadioButton();
        this.jRadioButtonGroupByDayAndHour = new JRadioButton();
        this.jButtonGroupTrainsInfo = new JButton();
        this.jPanelOutputDelay = new JPanel();
        this.jLabelOutputDelayCalculation = new JLabel();
        this.jRadioButtonOutDelayAtLastStation = new JRadioButton();
        this.jRadioButtonOutDelayAtAllStations = new JRadioButton();
        this.jButtonCalculateOutputDelayAtInfo = new JButton();
        this.jButtonSelectOutputFolder = new JButton();
        this.jLabelOutputFolder = new JLabel();
        this.jButtonSelectFolderInfo = new JButton();
        this.jToggleButtonCaseStudyMode = new JToggleButton();
        this.jToggleButtonCaseStudyMode.setUI(new MetalToggleButtonUI(){

            @Override
            protected Color getSelectColor() {
                return new Color(64, 224, 208);
            }
        });
        this.jToggleButtonDataAnalysis = new JToggleButton();
        this.jToggleButtonDataAnalysis.setUI(new MetalToggleButtonUI(){

            @Override
            protected Color getSelectColor() {
                return new Color(64, 224, 208);
            }
        });
        this.jButtonModeInfo = new JButton();
        this.jPanelRegressionParameters = new JPanel();
        this.jLabelAlpha = new JLabel();
        this.jLabelGamma = new JLabel();
        this.jTextFieldAlpha = new JTextField();
        this.jTextFieldGamma = new JTextField();
        this.jLabelDelta = new JLabel();
        this.jTextFieldDelta = new JTextField();
        this.jLabelEpsilon = new JLabel();
        this.jTextFieldEpsilon = new JTextField();
        this.jButtonRegressionParametersInfo = new JButton();
        this.jLabelBeta = new JLabel();
        this.jTextFieldBeta = new JTextField();
        this.setDefaultCloseOperation(3);
        this.setFont(new Font("Calibri Light", 0, 12));
        this.setMinimumSize(new Dimension(500, 640));
        this.jPanelMain.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonSelectWorkingFolder.setText("Select working folder");
        this.jButtonSelectWorkingFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButtonSelectWorkingFolderActionPerformed(evt);
            }
        });
        this.jButtonLoad.setText("Run");
        this.jButtonLoad.setEnabled(false);
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButtonLoadActionPerformed(evt);
            }
        });
        this.jTableHeadwayThresholds.setModel(this.thresholdsTM);
        this.jScrollPane1.setViewportView(this.jTableHeadwayThresholds);
        this.jButtonBufferThresholdsInfo.setText("?");
        this.jButtonBufferThresholdsInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButtonBufferThresholdsInfoActionPerformed(evt);
            }
        });
        GroupLayout jPanelBuffersLayout = new GroupLayout(this.jPanelBuffers);
        this.jPanelBuffers.setLayout(jPanelBuffersLayout);
        jPanelBuffersLayout.setHorizontalGroup(jPanelBuffersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBuffersLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 385, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonBufferThresholdsInfo).addContainerGap()));
        jPanelBuffersLayout.setVerticalGroup(jPanelBuffersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBuffersLayout.createSequentialGroup().addContainerGap().addGroup(jPanelBuffersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelBuffersLayout.createSequentialGroup().addComponent(this.jButtonBufferThresholdsInfo).addGap(0, 71, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPanePanes.addTab("Buffer thresholds", this.jPanelBuffers);
        this.jTable1.setModel(this.hoursTM);
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jButtonHoursInfo.setText("?");
        this.jButtonHoursInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButtonHoursInfoActionPerformed(evt);
            }
        });
        GroupLayout jPanelHoursLayout = new GroupLayout(this.jPanelHours);
        this.jPanelHours.setLayout(jPanelHoursLayout);
        jPanelHoursLayout.setHorizontalGroup(jPanelHoursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHoursLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 385, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHoursInfo).addContainerGap()));
        jPanelHoursLayout.setVerticalGroup(jPanelHoursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHoursLayout.createSequentialGroup().addContainerGap().addGroup(jPanelHoursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHoursLayout.createSequentialGroup().addComponent(this.jButtonHoursInfo).addGap(0, 71, Short.MAX_VALUE)).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPanePanes.addTab("Hours", this.jPanelHours);
        this.buttonGroupImportFiles.add(this.jRadioButtonSingleFiles);
        this.jRadioButtonSingleFiles.setSelected(true);
        this.jRadioButtonSingleFiles.setText("single files");
        this.buttonGroupImportFiles.add(this.jRadioButtonMultipleFolders);
        this.jRadioButtonMultipleFolders.setText("multiple folders");
        this.jTextAreaDataStatus.setEditable(false);
        this.jTextAreaDataStatus.setBackground(new Color(232, 232, 232));
        this.jTextAreaDataStatus.setColumns(20);
        this.jTextAreaDataStatus.setFont(new Font("Monospaced", 0, 11));
        this.jTextAreaDataStatus.setLineWrap(true);
        this.jTextAreaDataStatus.setRows(5);
        this.jTextAreaDataStatus.setText("Working folder: NONE\n\nPlease select working folder!\nFor further information, click on the \"?\" button.");
        this.jTextAreaDataStatus.setWrapStyleWord(true);
        this.jScrollPane3.setViewportView(this.jTextAreaDataStatus);
        this.jLabelDataInputStatus.setFont(new Font("Tahoma", 1, 11));
        this.jLabelDataInputStatus.setText("Current input data status:");
        this.jLabelTrainsGrouping.setFont(new Font("Tahoma", 1, 11));
        this.jLabelTrainsGrouping.setText("Group trains by:");
        this.buttonGroupTrainsGrouping.add(this.jRadioButtonGroupByDay);
        this.jRadioButtonGroupByDay.setSelected(true);
        this.jRadioButtonGroupByDay.setText("day");
        this.jRadioButtonGroupByDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jRadioButtonGroupByDayActionPerformed(evt);
            }
        });
        this.buttonGroupTrainsGrouping.add(this.jRadioButtonGroupByHour);
        this.jRadioButtonGroupByHour.setText("hour");
        this.jRadioButtonGroupByHour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jRadioButtonGroupByHourActionPerformed(evt);
            }
        });
        this.buttonGroupTrainsGrouping.add(this.jRadioButtonGroupByDayAndHour);
        this.jRadioButtonGroupByDayAndHour.setText("day and hour");
        this.jRadioButtonGroupByDayAndHour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jRadioButtonGroupByDayAndHourActionPerformed(evt);
            }
        });
        this.jButtonGroupTrainsInfo.setText("?");
        this.jButtonGroupTrainsInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButtonGroupTrainsInfoActionPerformed(evt);
            }
        });
        GroupLayout jPanelGroupTrainsLayout = new GroupLayout(this.jPanelGroupTrains);
        this.jPanelGroupTrains.setLayout(jPanelGroupTrainsLayout);
        jPanelGroupTrainsLayout.setHorizontalGroup(jPanelGroupTrainsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGroupTrainsLayout.createSequentialGroup().addComponent(this.jLabelTrainsGrouping).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonGroupTrainsInfo)).addGroup(jPanelGroupTrainsLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanelGroupTrainsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonGroupByDay).addComponent(this.jRadioButtonGroupByHour).addComponent(this.jRadioButtonGroupByDayAndHour))));
        jPanelGroupTrainsLayout.setVerticalGroup(jPanelGroupTrainsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGroupTrainsLayout.createSequentialGroup().addGroup(jPanelGroupTrainsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTrainsGrouping).addComponent(this.jButtonGroupTrainsInfo)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonGroupByDay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonGroupByHour).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonGroupByDayAndHour)));
        this.jLabelOutputDelayCalculation.setFont(new Font("Tahoma", 1, 11));
        this.jLabelOutputDelayCalculation.setText("Calculate output delay at:");
        this.buttonGroupOutputDelay.add(this.jRadioButtonOutDelayAtLastStation);
        this.jRadioButtonOutDelayAtLastStation.setSelected(true);
        this.jRadioButtonOutDelayAtLastStation.setText("last station");
        this.buttonGroupOutputDelay.add(this.jRadioButtonOutDelayAtAllStations);
        this.jRadioButtonOutDelayAtAllStations.setText("all stations");
        this.jButtonCalculateOutputDelayAtInfo.setText("?");
        this.jButtonCalculateOutputDelayAtInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButtonCalculateOutputDelayAtInfoActionPerformed(evt);
            }
        });
        GroupLayout jPanelOutputDelayLayout = new GroupLayout(this.jPanelOutputDelay);
        this.jPanelOutputDelay.setLayout(jPanelOutputDelayLayout);
        jPanelOutputDelayLayout.setHorizontalGroup(jPanelOutputDelayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelOutputDelayLayout.createSequentialGroup().addComponent(this.jLabelOutputDelayCalculation).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCalculateOutputDelayAtInfo)).addGroup(jPanelOutputDelayLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanelOutputDelayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonOutDelayAtLastStation).addComponent(this.jRadioButtonOutDelayAtAllStations))));
        jPanelOutputDelayLayout.setVerticalGroup(jPanelOutputDelayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOutputDelayLayout.createSequentialGroup().addGroup(jPanelOutputDelayLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOutputDelayCalculation).addComponent(this.jButtonCalculateOutputDelayAtInfo)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonOutDelayAtLastStation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonOutDelayAtAllStations).addGap(23, 23, 23)));
        this.jButtonSelectOutputFolder.setText("Select output folder");
        this.jButtonSelectOutputFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButtonSelectOutputFolderActionPerformed(evt);
            }
        });
        this.jLabelOutputFolder.setText("Selected folder: NONE");
        GroupLayout jPanelFilesInFolderLayout = new GroupLayout(this.jPanelFilesInFolder);
        this.jPanelFilesInFolder.setLayout(jPanelFilesInFolderLayout);
        jPanelFilesInFolderLayout.setHorizontalGroup(jPanelFilesInFolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilesInFolderLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFilesInFolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3).addGroup(jPanelFilesInFolderLayout.createSequentialGroup().addGroup(jPanelFilesInFolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelDataInputStatus).addGroup(jPanelFilesInFolderLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jPanelGroupTrains, -2, -1, -2).addGap(42, 42, 42).addComponent(this.jPanelOutputDelay, -2, -1, -2)).addGroup(jPanelFilesInFolderLayout.createSequentialGroup().addComponent(this.jButtonSelectOutputFolder).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelOutputFolder))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelFilesInFolderLayout.setVerticalGroup(jPanelFilesInFolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilesInFolderLayout.createSequentialGroup().addComponent(this.jLabelDataInputStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 60, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(jPanelFilesInFolderLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSelectOutputFolder).addComponent(this.jLabelOutputFolder)).addGap(18, 18, 18).addGroup(jPanelFilesInFolderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelGroupTrains, -2, -1, -2).addComponent(this.jPanelOutputDelay, -2, -1, -2)).addContainerGap()));
        this.jButtonSelectFolderInfo.setText("?");
        this.jButtonSelectFolderInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButtonSelectFolderInfoActionPerformed(evt);
            }
        });
        this.jToggleButtonCaseStudyMode.setSelected(true);
        this.jToggleButtonCaseStudyMode.setText("Case study mode");
        this.jToggleButtonCaseStudyMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jToggleButtonCaseStudyModeActionPerformed(evt);
            }
        });
        this.jToggleButtonDataAnalysis.setText("Data analysis mode");
        this.jToggleButtonDataAnalysis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jToggleButtonDataAnalysisActionPerformed(evt);
            }
        });
        this.jButtonModeInfo.setText("?");
        this.jButtonModeInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButtonModeInfoActionPerformed(evt);
            }
        });
        this.jPanelRegressionParameters.setBorder(BorderFactory.createTitledBorder("Regression parameters"));
        this.jPanelRegressionParameters.setFont(new Font("Tahoma", 1, 11));
        this.jLabelAlpha.setText("alpha =");
        this.jLabelGamma.setText("gamma =");
        this.jTextFieldAlpha.setText("0.0");
        this.jTextFieldAlpha.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainFrame.this.jTextFieldAlphaFocusLost(evt);
            }
        });
        this.jTextFieldGamma.setText("0.0");
        this.jTextFieldGamma.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainFrame.this.jTextFieldGammaFocusLost(evt);
            }
        });
        this.jLabelDelta.setText("delta =");
        this.jTextFieldDelta.setText("0.0");
        this.jTextFieldDelta.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainFrame.this.jTextFieldDeltaFocusLost(evt);
            }
        });
        this.jLabelEpsilon.setText("epsilon =");
        this.jTextFieldEpsilon.setText("0.0");
        this.jTextFieldEpsilon.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainFrame.this.jTextFieldEpsilonFocusLost(evt);
            }
        });
        this.jButtonRegressionParametersInfo.setText("?");
        this.jButtonRegressionParametersInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButtonRegressionParametersInfoActionPerformed(evt);
            }
        });
        this.jLabelBeta.setText("beta =");
        this.jTextFieldBeta.setText("0.0");
        this.jTextFieldBeta.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainFrame.this.jTextFieldBetaFocusLost(evt);
            }
        });
        GroupLayout jPanelRegressionParametersLayout = new GroupLayout(this.jPanelRegressionParameters);
        this.jPanelRegressionParameters.setLayout(jPanelRegressionParametersLayout);
        jPanelRegressionParametersLayout.setHorizontalGroup(jPanelRegressionParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRegressionParametersLayout.createSequentialGroup().addContainerGap().addGroup(jPanelRegressionParametersLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelAlpha).addComponent(this.jLabelDelta)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelRegressionParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldAlpha, -2, 50, -2).addComponent(this.jTextFieldDelta, -2, 50, -2)).addGap(30, 30, 30).addGroup(jPanelRegressionParametersLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanelRegressionParametersLayout.createSequentialGroup().addComponent(this.jLabelEpsilon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldEpsilon, -2, 50, -2)).addGroup(jPanelRegressionParametersLayout.createSequentialGroup().addComponent(this.jLabelBeta).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldBeta, -2, 50, -2))).addGap(30, 30, 30).addComponent(this.jLabelGamma).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldGamma, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonRegressionParametersInfo).addGap(8, 8, 8)));
        jPanelRegressionParametersLayout.setVerticalGroup(jPanelRegressionParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRegressionParametersLayout.createSequentialGroup().addGroup(jPanelRegressionParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRegressionParametersLayout.createSequentialGroup().addGroup(jPanelRegressionParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRegressionParametersLayout.createSequentialGroup().addContainerGap().addGroup(jPanelRegressionParametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelAlpha).addComponent(this.jTextFieldAlpha, -2, -1, -2).addComponent(this.jLabelGamma).addComponent(this.jTextFieldGamma, -2, -1, -2))).addComponent(this.jButtonRegressionParametersInfo)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelRegressionParametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDelta, -2, -1, -2).addComponent(this.jLabelDelta))).addGroup(jPanelRegressionParametersLayout.createSequentialGroup().addContainerGap().addGroup(jPanelRegressionParametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelBeta).addComponent(this.jTextFieldBeta, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelRegressionParametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldEpsilon, -2, -1, -2).addComponent(this.jLabelEpsilon)))).addContainerGap(16, Short.MAX_VALUE)));
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelFilesInFolder, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonLoad).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPanePanes).addGroup(jPanelMainLayout.createSequentialGroup().addComponent(this.jToggleButtonCaseStudyMode, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButtonDataAnalysis, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonModeInfo)).addGroup(jPanelMainLayout.createSequentialGroup().addComponent(this.jButtonSelectWorkingFolder).addGap(18, 18, 18).addComponent(this.jRadioButtonSingleFiles).addGap(18, 18, 18).addComponent(this.jRadioButtonMultipleFolders).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonSelectFolderInfo).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanelRegressionParameters, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButtonCaseStudyMode).addComponent(this.jToggleButtonDataAnalysis).addComponent(this.jButtonModeInfo)).addGap(18, 18, 18).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSelectWorkingFolder).addComponent(this.jRadioButtonSingleFiles).addComponent(this.jRadioButtonMultipleFolders).addComponent(this.jButtonSelectFolderInfo)).addGap(18, 18, 18).addComponent(this.jPanelFilesInFolder, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPanePanes).addGap(18, 18, 18).addComponent(this.jPanelRegressionParameters, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jButtonLoad).addContainerGap()));
        this.jTabbedPanePanes.getAccessibleContext().setAccessibleName("Buffer thresholds");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jButtonSelectWorkingFolderActionPerformed(ActionEvent evt) {
        this.changeWorkingFolder();
    }

    private boolean allFilesExist(Map<String, List<File>> fList) {
        for (String l : fList.keySet()) {
            for (File f : fList.get(l)) {
                if (f.exists()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean allCorridorFilesExist(Map<String, File> fList) {
        for (String l : fList.keySet()) {
            File f = fList.get(l);
            if (f.exists()) continue;
            return false;
        }
        return true;
    }

    private void loadData() {
        if (this.headwayFiles.isEmpty() || this.marginsFiles.isEmpty() || this.delaysFiles.isEmpty() || this.corridorFiles == null || !this.allFilesExist(this.headwayFiles) || !this.allFilesExist(this.marginsFiles) || !this.allFilesExist(this.delaysFiles) || !this.allCorridorFilesExist(this.corridorFiles)) {
            JOptionPane.showMessageDialog(this, "Some needed files were not found", "Error", 0);
            return;
        }
        if (this.outputFolder == null || !this.outputFolder.exists()) {
            JOptionPane.showMessageDialog(this, "Output folder not defined!", "Error", 0);
            return;
        }
        if (!this.jRadioButtonGroupByDay.isSelected() && !this.hoursTM.areHoursValid()) {
            JOptionPane.showMessageDialog(this, "Valid hour timebands must be defined first", "Error", 0);
            return;
        }
        this.data = new TrainsGroupsData();
        TrainGroupingMethod grouping = null;
        if (this.jRadioButtonGroupByDay.isSelected()) {
            grouping = TrainGroupingMethod.DAY;
        } else if (this.jRadioButtonGroupByHour.isSelected()) {
            grouping = TrainGroupingMethod.HOUR;
        } else if (this.jRadioButtonGroupByDayAndHour.isSelected()) {
            grouping = TrainGroupingMethod.DAY_HOUR;
        }
        PositioningMethod positioning = PositioningMethod.NONE;
        Integer nSteps = null;
        OutDelaysCalculationType calcType = this.jRadioButtonOutDelayAtAllStations.isSelected() ? OutDelaysCalculationType.ALL_STATIONS : OutDelaysCalculationType.LAST_STATION;
        UseMode useMode = this.jToggleButtonCaseStudyMode.isSelected() ? UseMode.CASE_STUDY : UseMode.DATA_ANALYSIS;
        ExecutionThread et = new ExecutionThread(this, this.data, this.headwayFiles, this.marginsFiles, this.secMarginsFiles, this.corridorFiles, this.delaysFiles, grouping, positioning, nSteps, this.hoursTM.getHours(), this.thresholdsTM.getThresholds(), this.alpha, this.beta, this.gamma, this.delta, this.epsilon, calcType, useMode, this.workingFolder.getAbsolutePath(), this.outputFolder.getAbsolutePath(), this.getParametersString());
        StatusFrame.showFrame(et);
        et.execute();
        this.setEnabled(false);
    }

    public void successfulThread() {
        this.setEnabled(true);
        if (this.data.getTrainsGroups().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Empty data!", "Error", 0);
            return;
        }
    }

    public void failedThread() {
        this.setEnabled(true);
    }

    private String getParametersString() {
        String strParam = this.jRadioButtonGroupByDay.isSelected() ? "day" : (this.jRadioButtonGroupByDayAndHour.isSelected() ? "dayhour" : "hour");
        strParam = strParam + "_" + (this.jRadioButtonOutDelayAtLastStation.isSelected() ? "last" : "all");
        return strParam;
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        this.loadData();
    }

    private void jRadioButtonGroupByDayActionPerformed(ActionEvent evt) {
        this.updateHoursTabEnabled();
    }

    private void jRadioButtonGroupByHourActionPerformed(ActionEvent evt) {
        this.updateHoursTabEnabled();
    }

    private void jRadioButtonGroupByDayAndHourActionPerformed(ActionEvent evt) {
        this.updateHoursTabEnabled();
    }

    private void jButtonSelectFolderInfoActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, SELECT_FOLDER_INFO_TEXT, "Select working folder...", 1);
    }

    private void jButtonGroupTrainsInfoActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Day: one group of trains per day\nHour: one group of train per hour (no distinction on days!)\nDay and hour: one group per day and hour (this creates the largest number of groups!)", "Group trains by...", 1);
    }

    private void jButtonCalculateOutputDelayAtInfoActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Last station: delays at intermediate stations are ignored\nAll stations: output delay is calculated as the sum of arrival delays at all stations", "Calculate output delay at...", 1);
    }

    private void jButtonModeInfoActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Case study mode: regression parameters are known and applied to grouped data to evaluate them as case studies\nData analysis mode: regression parameters are not considered and the program is only used to calculate group data\n\nOnly one of the two modes may be selected. The selected one is displayed in turquoise.", "What is mode selection?", 1);
    }

    private void jToggleButtonCaseStudyModeActionPerformed(ActionEvent evt) {
        this.jToggleButtonCaseStudyMode.setSelected(true);
        this.jToggleButtonDataAnalysis.setSelected(false);
        this.jLabelDataInputStatus.requestFocusInWindow();
        this.jPanelRegressionParameters.setVisible(true);
    }

    private void jToggleButtonDataAnalysisActionPerformed(ActionEvent evt) {
        this.jToggleButtonCaseStudyMode.setSelected(false);
        this.jToggleButtonDataAnalysis.setSelected(true);
        this.jLabelDataInputStatus.requestFocusInWindow();
        this.jPanelRegressionParameters.setVisible(false);
    }

    private void jTextFieldAlphaFocusLost(FocusEvent evt) {
        this.alpha = this.getDoubleValueFromTextFieldOrOld(this.jTextFieldAlpha, this.alpha);
        this.jTextFieldAlpha.setText("" + this.alpha);
    }

    private void jTextFieldGammaFocusLost(FocusEvent evt) {
        this.gamma = this.getDoubleValueFromTextFieldOrOld(this.jTextFieldGamma, this.gamma);
        this.jTextFieldGamma.setText("" + this.gamma);
    }

    private void jTextFieldDeltaFocusLost(FocusEvent evt) {
        this.delta = this.getDoubleValueFromTextFieldOrOld(this.jTextFieldDelta, this.delta);
        this.jTextFieldDelta.setText("" + this.delta);
    }

    private void jTextFieldEpsilonFocusLost(FocusEvent evt) {
        this.epsilon = this.getDoubleValueFromTextFieldOrOld(this.jTextFieldEpsilon, this.epsilon);
        this.jTextFieldEpsilon.setText("" + this.epsilon);
    }

    private void jButtonBufferThresholdsInfoActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Buffers are counted based on how many there are between two given values.\nFor example, if you specify minimum 0 and maximum 60 in a row, the number of buffers between 0 and 59 seconds is counted.\nIn the last row, the interval may be open, which is done by not specifying the ending of the interval.\n\nIn the case study mode, the beta column is used to specify the beta parameter from the regression associated to each buffers threshold.\nA value must be specified for each row.", "Buffer thresholds...", 1);
    }

    private void jButtonHoursInfoActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "If grouping is done using hours too, this is where you define the time intervals that form train groups.\nFor example, specifying from 5 to 10 groups together all trains that enter the considered corridor between 05:00:00 and 09:59:59.", "Hours...", 1);
    }

    private void jButtonSelectOutputFolderActionPerformed(ActionEvent evt) {
        this.changeOutputFolder();
    }

    private void jButtonRegressionParametersInfoActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Regression parameters have the following meaning:\n\nalpha: intercept\ngamma: coefficient multiplied by mean margin\ndelta: coefficient multiplied by mean positive input delay\nepsilon: coefficient multiplied by mean negative input delay\n\ndelay estimation = alpha + sum (t in thresholds) beta_t * buffer_t + gamma * mean_margin + delta * mean_pos_in_del + epsilon * mean_neg_in_del", "Regression parameters...", 1);
    }

    private void jTextFieldBetaFocusLost(FocusEvent evt) {
        this.beta = this.getDoubleValueFromTextFieldOrOld(this.jTextFieldBeta, this.beta);
        this.jTextFieldBeta.setText("" + this.beta);
    }

    private void updateHoursTabEnabled() {
        if (this.jRadioButtonGroupByDay.isSelected()) {
            this.jTabbedPanePanes.setSelectedIndex(0);
        }
        this.jTabbedPanePanes.setEnabledAt(1, !this.jRadioButtonGroupByDay.isSelected());
    }

    private void debugTrainGroups(TrainsGroupsData data) {
        for (TrainsGroup tg : data.getTrainsGroups()) {
            System.out.println("\n*** TRAIN GROUP NAME: " + tg.getName() + " (n. trains: " + tg.getTrains().size() + ") - In+ = " + tg.getPositiveInputDelays() + ", In- = " + tg.getNegativeInputDelays() + ", Out+ = " + tg.getOutputDelays() + " ***");
            for (Train t : tg.getTrains()) {
                System.out.println(t.getTrainNumber() + " (" + this.calendarToString(t.getOperationDate()) + ")");
            }
            System.out.println("");
        }
    }

    private String calendarToString(Calendar c) {
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
        return df.format(c.getTime());
    }

    private void debugBuffers(TrainsGroupsData data) {
        System.out.println("*** BUFFERS ***");
        for (TrainsGroup tg : data.getTrainsGroups()) {
            System.out.println("Trains group: " + tg.getName());
            for (String line : tg.getLineBuffers().keySet()) {
                System.out.println("Line: " + line);
                Map<BufferType, Buffers> bMap = tg.getLineBuffers().get(line).getBuffers();
                for (BufferType hType : bMap.keySet()) {
                    System.out.println("Buffer type: " + hType.name());
                    for (PositionBuffers pb : bMap.get((Object)hType).getPositionBuffers()) {
                        System.out.println("Position: " + pb.getPosition());
                        for (ThresholdBuffers tb : pb.getThresholdBuffers()) {
                            System.out.println("Threshold " + tb.getMin() + " to " + (tb.getMax() == null ? "INF" : tb.getMax()) + ": " + tb.getQuantity());
                        }
                    }
                }
            }
        }
    }

    private void debugMargins(TrainsGroupsData data) {
        for (TrainsGroup tg : data.getTrainsGroups()) {
            boolean tgw = false;
            for (PositionMargin pm : tg.getPositionMargins()) {
                if (!tgw) {
                    System.out.println("\n*** TRAINS GROUP : " + tg.getName() + " ***");
                    tgw = true;
                }
                System.out.println("Position: " + pm.getPosition() + " - Margin: " + pm.getTotalMargin());
            }
        }
    }

    private int getRandomInteger(int min, int max) {
        this.rand.nextInt();
        int next = this.rand.nextInt() % (max - min + 1);
        return next + min;
    }

    private double getRandomDouble(int min, int max) {
        this.rand.nextDouble();
        double next = this.rand.nextDouble();
        return (next *= (double)(max - min)) + (double)min;
    }

    private void changeWorkingFolder() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Choose working folder");
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        if (this.workingFolder != null && this.workingFolder.exists()) {
            chooser.setCurrentDirectory(this.workingFolder);
        }
        if (chooser.showOpenDialog(this) == 0) {
            this.workingFolder = chooser.getSelectedFile();
            this.delaysFiles = new HashMap<String, List<File>>();
            this.headwayFiles = new HashMap<String, List<File>>();
            this.marginsFiles = new HashMap<String, List<File>>();
            this.secMarginsFiles = new HashMap<String, List<File>>();
            this.corridorFiles = new HashMap<String, File>();
            if (this.jRadioButtonSingleFiles.isSelected()) {
                File df = new File(this.workingFolder.getAbsolutePath() + "/delays.csv");
                File hf = new File(this.workingFolder.getAbsolutePath() + "/headways.csv");
                File mf = new File(this.workingFolder.getAbsolutePath() + "/margins.csv");
                File secmf = new File(this.workingFolder.getAbsolutePath() + "/secmargins.csv");
                File cf = new File(this.workingFolder.getAbsolutePath() + "/corridor.csv");
                this.validInput = true;
                String delaysFileStatusStr = "delays.csv ";
                if (df.exists()) {
                    delaysFileStatusStr = delaysFileStatusStr + "found";
                } else {
                    delaysFileStatusStr = delaysFileStatusStr + "NOT FOUND";
                    this.validInput = false;
                }
                String headwaysFileStatusStr = "headways.csv ";
                if (hf.exists()) {
                    headwaysFileStatusStr = headwaysFileStatusStr + "found";
                } else {
                    headwaysFileStatusStr = headwaysFileStatusStr + "NOT FOUND";
                    this.validInput = false;
                }
                String marginsFileStatusStr = "margins.csv ";
                if (mf.exists()) {
                    marginsFileStatusStr = marginsFileStatusStr + "found";
                } else {
                    marginsFileStatusStr = marginsFileStatusStr + "NOT FOUND";
                    this.validInput = false;
                }
                String secondaryMarginsFileStatusStr = "secmargins.csv ";
                secondaryMarginsFileStatusStr = secmf.exists() ? secondaryMarginsFileStatusStr + "found" : secondaryMarginsFileStatusStr + "NOT FOUND (optional)";
                String corridorFileStatusStr = "corridor.csv ";
                if (cf.exists()) {
                    corridorFileStatusStr = corridorFileStatusStr + "found";
                } else {
                    corridorFileStatusStr = corridorFileStatusStr + "NOT FOUND";
                    this.validInput = false;
                }
                this.delaysFiles.put("single", new LinkedList());
                this.delaysFiles.get("single").add(df);
                this.headwayFiles.put("single", new LinkedList());
                this.headwayFiles.get("single").add(hf);
                this.marginsFiles.put("single", new LinkedList());
                this.marginsFiles.get("single").add(mf);
                this.secMarginsFiles.put("single", new LinkedList());
                this.secMarginsFiles.get("single").add(secmf);
                this.corridorFiles.put("single", cf);
                this.jTextAreaDataStatus.setText(MessageFormat.format(textAreaText, this.workingFolder.getAbsolutePath(), delaysFileStatusStr + "\n" + headwaysFileStatusStr + "\n" + marginsFileStatusStr + "\n" + secondaryMarginsFileStatusStr + "\n" + corridorFileStatusStr + "\n\nInput data are " + (this.validInput ? "valid!" : "NOT valid!")));
            } else {
                File[] filesInFolder = this.workingFolder.listFiles();
                ArrayList lines = null;
                this.validInput = false;
                ArrayList<String> errorStrings = new ArrayList<String>();
                for (File scenarioFolder : filesInFolder) {
                    if (!this.validInput && !errorStrings.isEmpty()) break;
                    if (!scenarioFolder.isDirectory()) continue;
                    File[] lineFolders = scenarioFolder.listFiles();
                    String scenario = scenarioFolder.getName();
                    ArrayList<String> currScenLines = new ArrayList<String>();
                    for (File lineFolder : lineFolders) {
                        File delFile;
                        if (!lineFolder.isDirectory() || !this.folderContainsNeededFiles(lineFolder)) continue;
                        String line = lineFolder.getName();
                        currScenLines.add(line);
                        if (!this.delaysFiles.containsKey(line)) {
                            this.validInput = true;
                            this.delaysFiles.put(line, new LinkedList());
                            this.headwayFiles.put(line, new LinkedList());
                            this.marginsFiles.put(line, new LinkedList());
                            this.secMarginsFiles.put(line, new LinkedList());
                            File corrFile = new File(lineFolder + "/corridor.csv");
                            if (!corrFile.exists()) {
                                this.validInput = false;
                                errorStrings.add("Missing corridor.csv");
                            }
                            this.corridorFiles.put(line, new File(lineFolder + "/corridor.csv"));
                        }
                        if ((delFile = new File(lineFolder + "/delays.csv")).exists()) {
                            this.delaysFiles.get(line).add(delFile);
                        } else {
                            this.validInput = false;
                            errorStrings.add("Missing delays.csv for line " + line + " and scenario " + scenario);
                        }
                        File hdwFile = new File(lineFolder + "/headways.csv");
                        if (hdwFile.exists()) {
                            this.headwayFiles.get(line).add(hdwFile);
                        } else {
                            this.validInput = false;
                            errorStrings.add("Missing headways.csv for line " + line + " and scenario " + scenario);
                        }
                        File margFile = new File(lineFolder + "/margins.csv");
                        if (margFile.exists()) {
                            this.marginsFiles.get(line).add(new File(lineFolder + "/margins.csv"));
                        } else {
                            this.validInput = false;
                            errorStrings.add("Missing margins.csv for line " + line + " and scenario " + scenario);
                        }
                        File secmargFile = new File(lineFolder + "/secmargins.csv");
                        if (!secmargFile.exists()) continue;
                        this.secMarginsFiles.get(line).add(new File(lineFolder + "/secmargins.csv"));
                    }
                    if (lines == null) {
                        lines = new ArrayList(currScenLines);
                    } else if (lines.size() != currScenLines.size()) {
                        errorStrings.add("Scenarios have different sets of lines!");
                        this.validInput = false;
                    } else {
                        for (String l : lines) {
                            if (currScenLines.contains(l)) continue;
                            errorStrings.add("Scenarios have different sets of lines!");
                            this.validInput = false;
                            break;
                        }
                    }
                    if (!this.validInput && !errorStrings.isEmpty()) break;
                }
                if (!errorStrings.isEmpty()) {
                    this.validInput = false;
                }
                String errorString = "";
                if (this.validInput) {
                    errorString = "Files in multiple folders successfully found!\n";
                } else if (errorStrings.isEmpty()) {
                    errorString = "No valid file found, expected the following structure:\nworking_folder -> 1 to N scenaro subfolders\nscenario_subfolder -> 1 to N line subfolders\nline_subfolder -> contain corridor, delays, headways, margins csv files\n\nexample: working_folder/scenario_subfolder/line_subfolder/corridor.csv";
                } else {
                    for (String errStr : errorStrings) {
                        errorString = errorString + errStr + "\n";
                    }
                }
                this.jTextAreaDataStatus.setText(MessageFormat.format(textAreaText, this.workingFolder.getAbsolutePath(), errorString));
            }
            this.jButtonLoad.setEnabled(this.outputFolder != null && this.validInput);
        }
    }

    private void changeOutputFolder() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Choose output folder");
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        if (this.outputFolder != null && this.outputFolder.exists()) {
            chooser.setCurrentDirectory(this.outputFolder);
        }
        if (chooser.showOpenDialog(this) == 0) {
            this.outputFolder = chooser.getSelectedFile();
            String displayedPath = this.outputFolder.getAbsolutePath();
            if (displayedPath.length() > 50) {
                displayedPath = "..." + displayedPath.substring(displayedPath.length() - 50);
            }
            this.jLabelOutputFolder.setText(displayedPath);
        }
        this.jButtonLoad.setEnabled(this.outputFolder != null && this.validInput);
    }

    private boolean folderContainsNeededFiles(File folder) {
        if (folder == null || !folder.isDirectory()) {
            return false;
        }
        LinkedList<String> filesInFolder = new LinkedList<String>();
        for (File f : folder.listFiles()) {
            filesInFolder.add(f.getName());
        }
        LinkedList<String> neededFiles = new LinkedList<String>();
        neededFiles.add("corridor.csv");
        neededFiles.add("margins.csv");
        neededFiles.add("headways.csv");
        neededFiles.add("delays.csv");
        for (String neededFile : neededFiles) {
            if (filesInFolder.contains(neededFile)) continue;
            return false;
        }
        return true;
    }

    private double getDoubleValueFromTextFieldOrOld(JTextField jtf, double oldValue) {
        try {
            return Double.parseDouble(jtf.getText());
        }
        catch (NumberFormatException nfe) {
            jtf.setText("" + oldValue);
            return oldValue;
        }
    }
}

