/*
 * Decompiled with CFR 0.152.
 */
package com.ficapacity.engine;

import com.ficapacity.engine.BufferType;
import com.ficapacity.engine.DataLoaderException;
import com.ficapacity.engine.DayPassTimes;
import com.ficapacity.engine.LineHeadways;
import com.ficapacity.engine.LineTimes;
import com.ficapacity.engine.PassTimes;
import com.ficapacity.engine.PositionException;
import com.ficapacity.engine.PositioningMethod;
import com.ficapacity.engine.ThresholdBuffers;
import com.ficapacity.engine.TimesManager;
import com.ficapacity.engine.Train;
import com.ficapacity.engine.TrainsGroup;
import com.ficapacity.engine.TrainsGroupNameException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TrainsGroupsData {
    private Map<String, Map<Integer, String>> corridors = new TreeMap<String, Map<Integer, String>>();
    private Map<String, TrainsGroup> trainsGroups = new HashMap<String, TrainsGroup>();
    private Map<String, Map<String, TrainsGroup>> tnDayTg = new HashMap<String, Map<String, TrainsGroup>>();
    private Map<String, Map<Integer, Integer>> positionMapping = new HashMap<String, Map<Integer, Integer>>();
    private TimesManager tManager = new TimesManager();
    private Map<String, LineHeadways> trainHeadwaysMap = new HashMap<String, LineHeadways>();

    public void setHeadway(String tn, BufferType hType, int pos, int hdwy) {
        if (!this.trainHeadwaysMap.containsKey(tn)) {
            this.trainHeadwaysMap.put(tn, new LineHeadways());
        }
        this.trainHeadwaysMap.get(tn).setHeadway(hType, pos, hdwy);
    }

    public Integer getHeadway(String tn, BufferType hType, int pos) {
        if (!this.trainHeadwaysMap.containsKey(tn)) {
            return null;
        }
        return this.trainHeadwaysMap.get(tn).getHeadway(hType, pos);
    }

    public void addTrainsGroup(TrainsGroup tg) throws TrainsGroupNameException {
        if (this.trainsGroups.containsKey(tg.getName())) {
            throw new TrainsGroupNameException(tg.getName());
        }
        this.trainsGroups.put(tg.getName(), tg);
        this.updateMap(tg.getLine(), tg.getName(), tg.getTrains());
    }

    private void updateMap(String line, String tgName, Set<Train> tSet) {
        if (!this.trainsGroups.containsKey(tgName)) {
            return;
        }
        if (!this.tnDayTg.containsKey(line)) {
            this.tnDayTg.put(line, new HashMap());
        }
        for (Train t : tSet) {
            this.tnDayTg.get(line).put(t.getTrainNumber() + "_" + DayPassTimes.getStringFromCalendar(t.getOperationDate()), this.trainsGroups.get(tgName));
        }
    }

    public Set<TrainsGroup> getTrainsGroups() {
        return new HashSet<TrainsGroup>(this.trainsGroups.values());
    }

    public Set<TrainsGroup> getLineTrainsGroup(String line) {
        HashSet<TrainsGroup> tgSet = new HashSet<TrainsGroup>();
        for (TrainsGroup tg : this.trainsGroups.values()) {
            if (!tg.getLine().equals(line)) continue;
            tgSet.add(tg);
        }
        return tgSet;
    }

    public void addCorridorPass(String line, int p, String station) throws DataLoaderException {
        if (!this.corridors.containsKey(line)) {
            this.corridors.put(line, new HashMap());
        }
        if (!this.corridors.get(line).containsKey(p)) {
            this.corridors.get(line).put(p, station);
        }
    }

    public Map<Integer, String> getCorridor(String line) {
        if (!this.corridors.containsKey(line)) {
            return new TreeMap<Integer, String>();
        }
        return new TreeMap<Integer, String>(this.corridors.get(line));
    }

    public boolean definePositionMapping(String line, PositioningMethod method, Integer nSteps) {
        if (this.corridors == null || !this.corridors.containsKey(line)) {
            return false;
        }
        HashMap<Integer, Integer> mapping = new HashMap<Integer, Integer>();
        int nPos = this.corridors.get(line).size();
        switch (method) {
            case NONE: {
                for (int p = 1; p <= nPos; ++p) {
                    mapping.put(p, 1);
                }
                break;
            }
            case PURE: {
                for (int p = 1; p <= nPos; ++p) {
                    mapping.put(p, p);
                }
                break;
            }
            case PERCENTAGE: {
                if (nSteps == null || nSteps <= 0 || nSteps > this.getPurePositions()) {
                    for (int p = 1; p <= nPos; ++p) {
                        mapping.put(p, 1);
                    }
                } else {
                    int lastAdded = 0;
                    for (int mapped = 1; mapped <= nSteps; ++mapped) {
                        int maxMapped = 1 + (int)Math.round(((double)nPos - 1.0) / (double)(nSteps - 1));
                        for (int p = lastAdded + 1; p <= maxMapped; ++p) {
                            mapping.put(p, mapped);
                        }
                        lastAdded = maxMapped;
                    }
                }
                break;
            }
        }
        this.positionMapping.put(line, mapping);
        return true;
    }

    public void addTrainToGroup(Train train, String group, String line, List<ThresholdBuffers> thresholds) {
        if (!this.trainsGroups.containsKey(group)) {
            this.trainsGroups.put(group, new TrainsGroup(group, line, 0.0, 0.0, 0.0, thresholds));
        }
        this.trainsGroups.get(group).addTrainToGroup(train);
        HashSet<Train> tSet = new HashSet<Train>();
        tSet.add(train);
        this.updateMap(line, group, tSet);
    }

    public void resetBufferTimes() {
        for (String line : this.trainsGroups.keySet()) {
            this.trainsGroups.get(line).resetBufferTimes();
        }
    }

    public boolean isStationInCorridor(String station, String line) {
        return this.corridors.containsKey(line) && this.corridors.get(line).values().contains(station);
    }

    public Set<TrainsGroup> getTrainsGroupsFromTrainNumberAndLine(String line, String tn) {
        HashSet<TrainsGroup> tgSet = new HashSet<TrainsGroup>();
        for (String tgName : this.trainsGroups.keySet()) {
            TrainsGroup tg = this.trainsGroups.get(tgName);
            if (!tg.isTrainNumberInGroup(tn, line)) continue;
            tgSet.add(tg);
        }
        return tgSet;
    }

    public TrainsGroup getTrainsGroupFromTrainNumberLineAndDay(String line, String tn, String day) {
        if (!this.tnDayTg.containsKey(line)) {
            return null;
        }
        return this.tnDayTg.get(line).get(tn + "_" + day);
    }

    public Map<String, Double> getTrainGroupsOutputDelays() {
        TreeMap<String, Double> tgMap = new TreeMap<String, Double>();
        for (TrainsGroup tg : this.getTrainsGroups()) {
            tgMap.put(tg.getName(), tg.getOutputDelays());
        }
        return tgMap;
    }

    public Map<String, Integer> getCorridorSizes() {
        HashMap<String, Integer> corridorSizes = new HashMap<String, Integer>();
        for (String line : this.corridors.keySet()) {
            corridorSizes.put(line, this.corridors.get(line).size());
        }
        return corridorSizes;
    }

    public int getPurePositions() {
        int max = 0;
        for (String line : this.corridors.keySet()) {
            if (this.corridors.get(line).size() <= max) continue;
            max = this.corridors.get(line).size();
        }
        return max;
    }

    public int getMappedPositions() {
        int max = 0;
        for (String line : this.positionMapping.keySet()) {
            for (int p : this.positionMapping.get(line).keySet()) {
                if (this.positionMapping.get(line).get(p) <= max) continue;
                max = this.positionMapping.get(line).get(p);
            }
        }
        return max;
    }

    public int getMappedPosition(String line, int pos) {
        if (this.positionMapping == null) {
            return 1;
        }
        if (!this.positionMapping.containsKey(line)) {
            return 1;
        }
        if (!this.positionMapping.get(line).containsKey(pos)) {
            return 1;
        }
        return this.positionMapping.get(line).get(pos);
    }

    public void resetLoadedTimes() {
        this.tManager = new TimesManager();
    }

    public void addDepartureTime(Calendar day, String line, int pass, String trainNumber, int time) {
        this.tManager.addTrainPassDepartureTimeOnLine(day, line, pass, trainNumber, time);
    }

    public void addArrivalTime(Calendar day, String line, int pass, String trainNumber, int time) {
        this.tManager.addTrainPassArrivalTimeOnLine(day, line, pass, trainNumber, time);
    }

    public List<Integer> getStationsPositionsOnLine(String line, String firstStation, String secondStation) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        if (!this.corridors.containsKey(line)) {
            return positions;
        }
        String lastStat = null;
        for (int pos : this.corridors.get(line).keySet()) {
            if (lastStat != null && lastStat.equals(firstStation) && this.corridors.get(line).get(pos).equals(secondStation)) {
                positions.add(pos - 1);
            }
            lastStat = this.corridors.get(line).get(pos);
        }
        return positions;
    }

    public void addPositionHeadway(String tn, BufferType hType, int p, int hdwy) {
        if (!this.trainHeadwaysMap.containsKey(tn)) {
            this.trainHeadwaysMap.put(tn, new LineHeadways());
        }
        this.trainHeadwaysMap.get(tn).setHeadway(hType, p, hdwy);
    }

    public void resetLineTimes(String line) {
        if (!this.tManager.getTimes().containsKey(line)) {
            return;
        }
        this.tManager.getTimes().remove(line);
    }

    public void calculateBufferTimes(String line) throws PositionException {
        if (!this.tManager.getTimes().containsKey(line)) {
            return;
        }
        DayPassTimes dpTimes = this.tManager.getTimes().get(line);
        for (String day : dpTimes.getTimes().keySet()) {
            LineTimes lt = dpTimes.getTimes().get(day);
            for (Integer pass : lt.getTimes().keySet()) {
                Integer plannedHdwy;
                TrainsGroup tg;
                int actHdwy;
                String tn;
                PassTimes pt = lt.getTimes().get(pass);
                Integer lastDep = null;
                Integer lastArr = null;
                Integer lastStatTime = null;
                for (Integer depTime : pt.getDepartureTimes().keySet()) {
                    tn = pt.getDepartureTimes().get(depTime);
                    if (lastDep != null) {
                        actHdwy = depTime - lastDep;
                        tg = this.getTrainsGroupFromTrainNumberLineAndDay(line, pt.getDepartureTimes().get(depTime), day);
                        plannedHdwy = this.getHeadway(tn, BufferType.INITIAL_EDGE, pass);
                        if (plannedHdwy != null && tg != null) {
                            tg.addBuffer(line, BufferType.INITIAL_EDGE, this.getMappedPosition(line, pass), plannedHdwy, actHdwy);
                        }
                    }
                    lastDep = depTime;
                }
                for (Integer arrTime : pt.getArrivalTimes().keySet()) {
                    tn = pt.getArrivalTimes().get(arrTime);
                    if (lastArr != null) {
                        actHdwy = arrTime - lastArr;
                        tg = this.getTrainsGroupFromTrainNumberLineAndDay(line, pt.getArrivalTimes().get(arrTime), day);
                        plannedHdwy = this.getHeadway(tn, BufferType.FINAL_EDGE, pass - 1);
                        if (plannedHdwy != null && tg != null) {
                            tg.addBuffer(line, BufferType.FINAL_EDGE, this.getMappedPosition(line, pass - 1), plannedHdwy, actHdwy);
                        }
                    }
                    lastArr = arrTime;
                }
                String lastStatTn = "";
                for (Integer statTime : pt.getStationTimes().keySet()) {
                    String tn2 = pt.getStationTimes().get(statTime);
                    if (lastStatTime != null && !tn2.equals(lastStatTn)) {
                        int actHdwy2 = statTime - lastStatTime;
                        TrainsGroup tg2 = this.getTrainsGroupFromTrainNumberLineAndDay(line, pt.getStationTimes().get(statTime), day);
                        Integer plannedHdwy2 = this.getHeadway(tn2, BufferType.STATION, pass);
                        if (plannedHdwy2 != null && tg2 != null) {
                            tg2.addBuffer(line, BufferType.STATION, this.getMappedPosition(line, pass), plannedHdwy2, actHdwy2);
                        }
                    }
                    lastStatTime = statTime;
                    lastStatTn = tn2;
                }
            }
        }
    }

    public Set<Train> getAllTrains() {
        HashSet<Train> allTrains = new HashSet<Train>();
        for (TrainsGroup tg : this.trainsGroups.values()) {
            allTrains.addAll(tg.getTrains());
        }
        return allTrains;
    }

    public boolean isTrainTravellingOnLinePass(String tn, String line, int pass) {
        for (DayPassTimes dpt : this.tManager.getTimes().values()) {
            for (LineTimes lt : dpt.getTimes().values()) {
                TreeMap<Integer, PassTimes> mapTimes = lt.getTimes();
                if (!mapTimes.containsKey(pass) || !mapTimes.containsKey(pass + 1) || !((PassTimes)mapTimes.get(pass)).getDepartureTimes().containsValue(tn) || !((PassTimes)mapTimes.get(pass + 1)).getArrivalTimes().containsValue(lt)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getTrainNumbersTravellingOnLinePass(String line, int pass) {
        HashSet<String> tns = new HashSet<String>();
        for (DayPassTimes dpt : this.tManager.getTimes().values()) {
            for (LineTimes lt : dpt.getTimes().values()) {
                TreeMap<Integer, PassTimes> mapTimes = lt.getTimes();
                if (!mapTimes.containsKey(pass) || !mapTimes.containsKey(pass + 1)) continue;
                HashSet<String> tns1 = new HashSet<String>(((PassTimes)mapTimes.get(pass)).getDepartureTimes().values());
                HashSet<String> tns2 = new HashSet<String>(((PassTimes)mapTimes.get(pass + 1)).getArrivalTimes().values());
                tns1.retainAll(tns2);
                tns.addAll(tns1);
            }
        }
        return tns;
    }

    public Collection<String> getLines() {
        return this.corridors.keySet();
    }
}

