/*
 * Decompiled with CFR 0.152.
 */
package com.ficapacity.engine;

import com.ficapacity.engine.ThresholdBuffers;
import java.util.LinkedList;
import java.util.List;

public class PositionBuffers {
    private int position;
    private List<ThresholdBuffers> thresholdBuffers;

    public PositionBuffers(int position) {
        this.position = position;
        this.thresholdBuffers = new LinkedList<ThresholdBuffers>();
    }

    public PositionBuffers(PositionBuffers ph) {
        this(ph.position);
        for (ThresholdBuffers th : ph.thresholdBuffers) {
            this.thresholdBuffers.add(new ThresholdBuffers(th));
        }
    }

    public void addThresholdBuffers(ThresholdBuffers tbToAdd) {
        if (tbToAdd == null) {
            return;
        }
        for (ThresholdBuffers tb : this.thresholdBuffers) {
            if (tb.getMin() != tbToAdd.getMin()) continue;
            tb.addTrains(tbToAdd.getQuantity());
            return;
        }
        this.thresholdBuffers.add(new ThresholdBuffers(tbToAdd));
    }

    public List<ThresholdBuffers> getThresholdBuffers() {
        return new LinkedList<ThresholdBuffers>(this.thresholdBuffers);
    }

    public int getPosition() {
        return this.position;
    }

    public boolean addBuffer(int buffer) {
        for (ThresholdBuffers th : this.thresholdBuffers) {
            if (th.getMin() > buffer || th.getMax() != null && th.getMax() <= buffer) continue;
            th.addTrain();
            return true;
        }
        return false;
    }

    public Integer getThresholdBuffer(int t) {
        for (ThresholdBuffers th : this.thresholdBuffers) {
            if (th.getMin() != t) continue;
            return th.getQuantity();
        }
        return null;
    }
}

