/*
 * Decompiled with CFR 0.152.
 */
package com.ficapacity.engine;

import com.ficapacity.engine.BufferType;
import com.ficapacity.engine.LineBuffers;
import com.ficapacity.engine.PositionException;
import com.ficapacity.engine.ThresholdBuffers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HeadwayBuffersManager {
    private Map<String, LineBuffers> lineBuffersMap = new HashMap<String, LineBuffers>();
    private List<ThresholdBuffers> thresholds;
    private Integer maxHeadway = null;

    public HeadwayBuffersManager(List<ThresholdBuffers> thresholds) {
        this.thresholds = thresholds;
    }

    public void setMaxHeadway(int maxVal) {
        this.maxHeadway = maxVal;
    }

    public void addBufferFromActualHeadway(String line, BufferType hType, int pos, int plannedHdwy, int actHdwy) throws PositionException {
        int buffer = Math.max(actHdwy - Math.min(plannedHdwy, this.maxHeadway != null ? this.maxHeadway : Integer.MAX_VALUE), 0);
        if (!this.lineBuffersMap.containsKey(line)) {
            this.lineBuffersMap.put(line, new LineBuffers(this.thresholds));
        }
        this.lineBuffersMap.get(line).addBuffer(hType, pos, buffer);
    }

    public Map<String, LineBuffers> getLineBuffers() {
        return this.lineBuffersMap;
    }

    public void resetBufferTimes() {
        this.lineBuffersMap.clear();
    }

    public double getBufferCriticality(String line, int nPositions, int nTrains) {
        double val = 0.0;
        if (nTrains <= 0) {
            return val;
        }
        if (this.lineBuffersMap.containsKey(line)) {
            for (ThresholdBuffers tBuffers : this.thresholds) {
                Integer b = tBuffers.getMax();
                if (b == null) continue;
                double wb = Math.pow(2.0, -((double)b.intValue() / 60.0));
                for (int p = 1; p <= nPositions; ++p) {
                    Integer bval = this.lineBuffersMap.get(line).getBuffer(BufferType.FINAL_EDGE, p, tBuffers.getMin());
                    if (bval == null) continue;
                    val += wb * (double)bval.intValue();
                }
            }
        }
        return val / (double)nTrains;
    }
}

